/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.mapreduce;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.pentaho.di.job.entries.hadoopjobexecutor.NoExitSecurityManager;
import org.pentaho.di.job.entries.hadoopjobexecutor.SecurityManagerStack;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceExecutionException;

public class FutureMapReduceJobSimpleRunnable
implements Runnable {
    private static final SecurityManagerStack securityManagerStack = SecurityManagerStack.getInstance();
    private final Class<?> mainClass;
    private final String commandLineArgs;
    private final AtomicBoolean complete;
    private final AtomicInteger status;
    private final AtomicReference<MapReduceExecutionException> exceptionAtomicReference;

    public FutureMapReduceJobSimpleRunnable(Class<?> mainClass, String commandLineArgs, AtomicBoolean complete, AtomicInteger status, AtomicReference<MapReduceExecutionException> exceptionAtomicReference) {
        this.mainClass = mainClass;
        this.commandLineArgs = commandLineArgs;
        this.complete = complete;
        this.status = status;
        this.exceptionAtomicReference = exceptionAtomicReference;
    }

    @Override
    public void run() {
        NoExitSecurityManager nesm = new NoExitSecurityManager(System.getSecurityManager());
        securityManagerStack.setSecurityManager(nesm);
        try {
            nesm.addBlockedThread(Thread.currentThread());
            try {
                this.executeMainMethod(this.mainClass, this.commandLineArgs);
                this.updateWithStatus(0, null);
            }
            finally {
                nesm.removeBlockedThread(Thread.currentThread());
                securityManagerStack.removeSecurityManager(nesm);
            }
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            if (ex instanceof NoExitSecurityManager.NoExitSecurityException) {
                this.updateWithStatus(((NoExitSecurityManager.NoExitSecurityException)ex).getStatus(), null);
            }
            this.updateWithStatus(-1, new MapReduceExecutionException(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMainMethod(Class<?> clazz, String commandLineArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Object[] objectArray;
            Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
            Method mainMethod = clazz.getMethod("main", String[].class);
            if (commandLineArgs != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = commandLineArgs.split(" ");
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = new String[0];
            }
            Object[] args = objectArray;
            mainMethod.invoke(null, args);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void updateWithStatus(int status, MapReduceExecutionException exception) {
        this.complete.set(true);
        this.status.set(status);
        this.exceptionAtomicReference.set(exception);
    }

    public AtomicBoolean getComplete() {
        return this.complete;
    }

    public AtomicInteger getStatus() {
        return this.status;
    }

    public AtomicReference<MapReduceExecutionException> getExceptionAtomicReference() {
        return this.exceptionAtomicReference;
    }
}

