/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;
import org.pentaho.hadoop.shim.common.format.BaseFormatInputField;

public class AvroInputField
extends BaseFormatInputField
implements IAvroInputField {
    private List<String> pathParts;
    private List<String> indexedVals = new ArrayList<String>();
    private ValueMetaInterface tempValueMeta;
    private List<String> tempParts;
    private int outputIndex;

    int getOutputIndex() {
        return this.outputIndex;
    }

    void setOutputIndex(int outputIndex) {
        this.outputIndex = outputIndex;
    }

    void setPathParts(List<String> pathParts) {
        this.pathParts = pathParts;
    }

    List<String> getPathParts() {
        return this.pathParts;
    }

    ValueMetaInterface getTempValueMeta() {
        return this.tempValueMeta;
    }

    void setTempValueMeta(ValueMetaInterface tempValueMeta) {
        this.tempValueMeta = tempValueMeta;
    }

    List<String> getTempParts() {
        return this.tempParts;
    }

    void setTempParts(List<String> tempParts) {
        this.tempParts = tempParts;
    }

    public void setIndexedVals(List<String> indexedVals) {
        this.indexedVals = indexedVals;
    }

    private void initIndexedVals() {
        int bracketPos = this.formatFieldName.indexOf(91);
        if (this.indexedVals.isEmpty() && bracketPos > -1) {
            int closeBracketPos = this.formatFieldName.indexOf(93);
            String values = this.formatFieldName.substring(bracketPos + 1, closeBracketPos);
            this.indexedVals = Arrays.asList(values.split("\\s*,\\s*"));
        }
    }

    public List<String> getIndexedVals() {
        this.initIndexedVals();
        return this.indexedVals;
    }

    public String getIndexedValues() {
        return String.join((CharSequence)" , ", this.getIndexedVals());
    }

    public void setIndexedValues(String indexedValues) {
        this.setIndexedVals(Arrays.asList(indexedValues.split("\\s*,\\s*")));
    }

    public String getAvroFieldName() {
        return this.formatFieldName;
    }

    @Override
    public void setFormatFieldName(String formatFieldName) {
        this.setAvroFieldName(formatFieldName);
    }

    public void setAvroFieldName(String avroFieldName) {
        this.formatFieldName = avroFieldName;
        this.initIndexedVals();
    }

    public AvroSpec.DataType getAvroType() {
        return AvroSpec.DataType.getDataType((int)this.getFormatType());
    }

    public void setAvroType(AvroSpec.DataType avroType) {
        this.setFormatType(avroType.getId());
    }

    public void setAvroType(String avroType) {
        for (AvroSpec.DataType tmpType : AvroSpec.DataType.values()) {
            if (!tmpType.getName().equalsIgnoreCase(avroType)) continue;
            this.setFormatType(tmpType.getId());
            break;
        }
    }

    public String getDisplayableAvroFieldName() {
        return this.formatFieldName;
    }
}

