/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.hadoop.shim.common.format.avro.AvroInputField;
import org.pentaho.hadoop.shim.common.format.avro.AvroToPdiConverter;

public class AvroNestedReader {
    protected DataFileStream m_containerReader;
    protected GenericData.Record m_topLevelRecord;
    protected GenericData.Array m_topLevelArray;
    protected Map<Utf8, Object> m_topLevelMap;
    protected boolean m_decodingFromField;
    protected LogChannelInterface m_log;
    protected RowMetaInterface m_incomingRowMeta;
    protected RowMetaInterface m_outputRowMeta;
    protected GenericDatumReader m_datumReader;
    protected Decoder m_decoder;
    protected InputStream m_inStream;
    protected Schema m_writerSchema;
    protected Schema m_schemaToUse;
    protected Schema m_defaultSchema;
    protected GenericDatumReader m_defaultDatumReader;
    protected Object m_defaultTopLevelObject;
    protected Map<String, Object[]> m_schemaCache = new HashMap<String, Object[]>();
    protected boolean m_jsonEncoded;
    protected List<AvroInputField> m_normalFields;
    protected AvroArrayExpansion m_expansionHandler;
    protected int m_newFieldOffset;
    protected int m_fieldToDecodeIndex = -1;
    protected boolean m_schemaInField;
    protected int m_schemaFieldIndex = -1;
    protected boolean m_schemaFieldIsPath;
    protected boolean m_cacheSchemas;
    protected boolean m_dontComplainAboutMissingFields;
    protected DataFileStream<Object> m_avroDataFileStream;
    protected AvroToPdiConverter m_avroToPdiConverter;
    protected DecoderFactory m_factory;
    protected static Class<?> PKG = AvroNestedReader.class;

    protected void init() throws KettleException {
        if (this.m_schemaToUse != null) {
            this.m_avroToPdiConverter = new AvroToPdiConverter(this.m_schemaToUse);
            this.initTopLevelStructure(this.m_schemaToUse, true);
        }
        if (this.m_normalFields == null || this.m_normalFields.size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.NoFieldPathsDefined", (String[])new String[0]));
        }
        this.m_expansionHandler = this.checkFieldPaths(this.m_normalFields, this.m_outputRowMeta);
        int killmeIndex = 0;
        for (AvroInputField f : this.m_normalFields) {
            int outputIndex = killmeIndex++;
            this.fieldInit(f, outputIndex);
        }
        if (this.m_expansionHandler != null) {
            this.m_expansionHandler.init();
        }
        this.m_factory = new DecoderFactory();
    }

    public void resetField(AvroInputField avroInputField, VariableSpace space) {
        avroInputField.getTempParts().clear();
        for (String part : avroInputField.getPathParts()) {
            if (space == null) {
                avroInputField.getTempParts().add(part);
                continue;
            }
            avroInputField.getTempParts().add(space.environmentSubstitute(part));
        }
    }

    public void fieldInit(AvroInputField avroInputField, int outputIndex) throws KettleException {
        if (Const.isEmpty((String)avroInputField.getAvroFieldName())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.NoPathSet", (String[])new String[0]));
        }
        if (avroInputField.getPathParts() != null) {
            return;
        }
        String fieldPath = AvroNestedReader.cleansePath(avroInputField.getAvroFieldName());
        String[] temp = fieldPath.split("\\.");
        ArrayList<String> pathParts = new ArrayList<String>();
        avroInputField.setPathParts(pathParts);
        for (String part : temp) {
            pathParts.add(part);
        }
        if (((String)pathParts.get(0)).equals("$")) {
            pathParts.remove(0);
        } else if (((String)pathParts.get(0)).startsWith("$[")) {
            String r = ((String)pathParts.get(0)).substring(1, ((String)pathParts.get(0)).length());
            pathParts.set(0, r);
        }
        avroInputField.setTempParts(new ArrayList<String>());
        ValueMeta resetMeta = new ValueMeta();
        resetMeta.setType(avroInputField.getPentahoType());
        avroInputField.setTempValueMeta((ValueMetaInterface)resetMeta);
        avroInputField.setOutputIndex(outputIndex);
    }

    protected void initTopLevelStructure(Schema schema, boolean setDefault) throws KettleException {
        if (schema.getType() == Schema.Type.RECORD) {
            this.m_topLevelRecord = new GenericData.Record(schema);
            if (setDefault) {
                this.m_defaultTopLevelObject = this.m_topLevelRecord;
            }
        } else if (schema.getType() == Schema.Type.UNION) {
            Schema firstUnion = null;
            for (Schema uS : schema.getTypes()) {
                if (uS.getType() != Schema.Type.RECORD) continue;
                firstUnion = uS;
                break;
            }
            this.m_topLevelRecord = new GenericData.Record(firstUnion);
            if (setDefault) {
                this.m_defaultTopLevelObject = this.m_topLevelRecord;
            }
        } else if (schema.getType() == Schema.Type.ARRAY) {
            this.m_topLevelArray = new GenericData.Array(1, schema);
            if (setDefault) {
                this.m_defaultTopLevelObject = this.m_topLevelArray;
            }
        } else if (schema.getType() == Schema.Type.MAP) {
            this.m_topLevelMap = new HashMap<Utf8, Object>();
            if (setDefault) {
                this.m_defaultTopLevelObject = this.m_topLevelMap;
            }
        } else {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnsupportedTopLevelStructure", (String[])new String[0]));
        }
    }

    protected AvroArrayExpansion checkFieldPaths(List<AvroInputField> normalFields, RowMetaInterface outputRowMeta) throws KettleException {
        String expansion = null;
        ArrayList<AvroInputField> normalList = new ArrayList<AvroInputField>();
        ArrayList<AvroInputField> expansionList = new ArrayList<AvroInputField>();
        for (AvroInputField avroInputField : normalFields) {
            String string = avroInputField.getAvroFieldName();
            if (string != null && string.lastIndexOf("[*]") >= 0) {
                if (string.indexOf("[*]") != string.lastIndexOf("[*]")) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.PathContainsMultipleExpansions", (String[])new String[]{string}));
                }
                String pathPart = string.substring(0, string.lastIndexOf("[*]") + 3);
                if (expansion == null) {
                    expansion = pathPart;
                } else if (!expansion.equals(pathPart)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MutipleDifferentExpansions", (String[])new String[0]));
                }
                expansionList.add(avroInputField);
                continue;
            }
            normalList.add(avroInputField);
        }
        normalFields.clear();
        for (AvroInputField avroInputField : normalList) {
            normalFields.add(avroInputField);
        }
        if (expansionList.size() > 0) {
            ArrayList<AvroInputField> subFields = new ArrayList<AvroInputField>();
            for (AvroInputField avroInputField : expansionList) {
                AvroInputField subField = new AvroInputField();
                subField.setPentahoFieldName(avroInputField.getPentahoFieldName());
                String path = avroInputField.getAvroFieldName();
                if (path.charAt(path.length() - 2) == '*') {
                    path = "dummy";
                } else {
                    path = path.substring(path.lastIndexOf("[*]") + 3, path.length());
                    path = "$" + path;
                }
                subField.setAvroFieldName(path);
                subField.setIndexedVals(avroInputField.getIndexedVals());
                subField.setPentahoType(avroInputField.getPentahoType());
                subFields.add(subField);
            }
            AvroArrayExpansion avroArrayExpansion = new AvroArrayExpansion(subFields);
            avroArrayExpansion.m_expansionPath = expansion;
            avroArrayExpansion.m_outputRowMeta = outputRowMeta;
            return avroArrayExpansion;
        }
        return null;
    }

    public Object convertToKettleValue(AvroInputField avroInputField, Map<Utf8, Object> map, Schema s, Schema defaultSchema, boolean ignoreMissing) throws KettleException {
        Object value;
        if (map == null) {
            return null;
        }
        if (avroInputField.getTempParts().size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathMap", (String[])new String[0]));
        }
        String part = avroInputField.getTempParts().remove(0);
        if (part.charAt(0) != '[') {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathMap2", (String[])new String[]{part}));
        }
        String key = part.substring(1, part.indexOf(93));
        if (part.indexOf(93) < part.length() - 1) {
            part = part.substring(part.indexOf(93) + 1, part.length());
            avroInputField.getTempParts().add(0, part);
        }
        if ((value = map.get(new Utf8(key))) == null) {
            return null;
        }
        Schema valueType = s.getValueType();
        if (valueType.getType() == Schema.Type.UNION) {
            if (value instanceof GenericContainer) {
                valueType = ((GenericContainer)value).getSchema();
            } else if (value instanceof Map) {
                Schema mapSchema = null;
                for (Schema ts : valueType.getTypes()) {
                    if (ts.getType() != Schema.Type.MAP) continue;
                    mapSchema = ts;
                    break;
                }
                if (mapSchema == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                }
                valueType = mapSchema;
            } else {
                valueType = avroInputField.getTempValueMeta().getType() != 2 ? AvroNestedReader.checkUnion(valueType) : Schema.create((Schema.Type)Schema.Type.STRING);
            }
        }
        if (valueType.getType() == Schema.Type.RECORD) {
            return this.convertToKettleValue(avroInputField, (GenericData.Record)value, valueType, defaultSchema, ignoreMissing);
        }
        if (valueType.getType() == Schema.Type.ARRAY) {
            return this.convertToKettleValue(avroInputField, (GenericData.Array)value, valueType, defaultSchema, ignoreMissing);
        }
        if (valueType.getType() == Schema.Type.MAP) {
            return this.convertToKettleValue(avroInputField, (Map)value, valueType, defaultSchema, ignoreMissing);
        }
        return this.getPrimitive(avroInputField, value, valueType);
    }

    public Object convertToKettleValue(AvroInputField avroInputField, GenericData.Array array, Schema s, Schema defaultSchema, boolean ignoreMissing) throws KettleException {
        if (array == null) {
            return null;
        }
        if (avroInputField.getTempParts().size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathArray", (String[])new String[0]));
        }
        String part = avroInputField.getTempParts().remove(0);
        if (part.charAt(0) != '[') {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathArray2", (String[])new String[]{part}));
        }
        String index = part.substring(1, part.indexOf(93));
        int arrayI = 0;
        try {
            arrayI = Integer.parseInt(index.trim());
        }
        catch (NumberFormatException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToParseArrayIndex", (String[])new String[]{index}));
        }
        if (part.indexOf(93) < part.length() - 1) {
            part = part.substring(part.indexOf(93) + 1, part.length());
            avroInputField.getTempParts().add(0, part);
        }
        if (arrayI >= array.size() || arrayI < 0) {
            return null;
        }
        Object element = array.get(arrayI);
        Schema elementType = s.getElementType();
        if (element == null) {
            return null;
        }
        if (elementType.getType() == Schema.Type.UNION) {
            if (element instanceof GenericContainer) {
                elementType = ((GenericContainer)element).getSchema();
            } else if (element instanceof Map) {
                Schema mapSchema = null;
                for (Schema ts : elementType.getTypes()) {
                    if (ts.getType() != Schema.Type.MAP) continue;
                    mapSchema = ts;
                    break;
                }
                if (mapSchema == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                }
                elementType = mapSchema;
            } else {
                elementType = avroInputField.getTempValueMeta().getType() != 2 ? AvroNestedReader.checkUnion(elementType) : Schema.create((Schema.Type)Schema.Type.STRING);
            }
        }
        if (elementType.getType() == Schema.Type.RECORD) {
            return this.convertToKettleValue(avroInputField, (GenericData.Record)element, elementType, defaultSchema, ignoreMissing);
        }
        if (elementType.getType() == Schema.Type.ARRAY) {
            return this.convertToKettleValue(avroInputField, (GenericData.Array)element, elementType, defaultSchema, ignoreMissing);
        }
        if (elementType.getType() == Schema.Type.MAP) {
            return this.convertToKettleValue(avroInputField, (Map)element, elementType, defaultSchema, ignoreMissing);
        }
        return this.getPrimitive(avroInputField, element, elementType);
    }

    public Object convertToKettleValue(AvroInputField avroInputField, GenericData.Record record, Schema s, Schema defaultSchema, boolean ignoreMissing) throws KettleException {
        Schema.Field fieldS;
        if (record == null) {
            return null;
        }
        if (avroInputField.getTempParts().size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathRecord", (String[])new String[0]));
        }
        String part = avroInputField.getTempParts().remove(0);
        if (part.charAt(0) == '[') {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.InvalidPath", (String[])new String[0]) + avroInputField.getTempParts());
        }
        if (part.indexOf(91) > 0) {
            String arrayPart = part.substring(part.indexOf(91));
            part = part.substring(0, part.indexOf(91));
            avroInputField.getTempParts().add(0, arrayPart);
        }
        if ((fieldS = s.getField(part)) == null && !ignoreMissing) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.NonExistentField", (String[])new String[]{part}));
        }
        Object field = record.get(part);
        if (field == null) {
            if (defaultSchema != null) {
                fieldS = defaultSchema.getField(part);
            }
            if (fieldS == null || fieldS.defaultValue() == null) {
                return null;
            }
            field = fieldS.defaultValue();
        }
        Schema.Type fieldT = fieldS.schema().getType();
        Schema fieldSchema = fieldS.schema();
        if (fieldT == Schema.Type.UNION) {
            if (field instanceof GenericContainer) {
                fieldSchema = ((GenericContainer)field).getSchema();
                fieldT = fieldSchema.getType();
            } else if (field instanceof Map) {
                Schema mapSchema = null;
                for (Schema ts : fieldSchema.getTypes()) {
                    if (ts.getType() != Schema.Type.MAP) continue;
                    mapSchema = ts;
                    break;
                }
                if (mapSchema == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                }
                fieldSchema = mapSchema;
                fieldT = Schema.Type.MAP;
            } else {
                fieldSchema = AvroNestedReader.checkUnion(fieldSchema);
                fieldT = fieldSchema.getType();
            }
        }
        if (fieldT == Schema.Type.RECORD) {
            return this.convertToKettleValue(avroInputField, (GenericData.Record)field, fieldSchema, defaultSchema, ignoreMissing);
        }
        if (fieldT == Schema.Type.ARRAY) {
            return this.convertToKettleValue(avroInputField, (GenericData.Array)field, fieldSchema, defaultSchema, ignoreMissing);
        }
        if (fieldT == Schema.Type.MAP) {
            return this.convertToKettleValue(avroInputField, (Map)field, fieldSchema, defaultSchema, ignoreMissing);
        }
        if (fieldT == Schema.Type.BYTES) {
            return this.convertToKettleValue(avroInputField, (ByteBuffer)field, fieldSchema);
        }
        return this.getPrimitive(avroInputField, field, fieldSchema);
    }

    public Object convertToKettleValue(AvroInputField pentahoType, ByteBuffer avroData, Schema fieldSchema) {
        Object pentahoData = null;
        if (avroData != null) {
            try {
                switch (pentahoType.getPentahoType()) {
                    case 6: {
                        Conversions.DecimalConversion converter = new Conversions.DecimalConversion();
                        Schema schema = fieldSchema;
                        if (schema.getType().equals((Object)Schema.Type.UNION)) {
                            List schemas = schema.getTypes();
                            for (Schema s : schemas) {
                                if (s.getName().equalsIgnoreCase("null")) continue;
                                schema = s;
                                break;
                            }
                        }
                        Object precision = schema.getObjectProp("precision");
                        Object scale = schema.getObjectProp("scale");
                        LogicalTypes.Decimal decimalType = LogicalTypes.decimal((int)Integer.parseInt(precision.toString()), (int)Integer.parseInt(scale.toString()));
                        pentahoData = converter.fromBytes(avroData, this.m_schemaToUse, (LogicalType)decimalType);
                        break;
                    }
                    case 8: {
                        pentahoData = new byte[avroData.remaining()];
                        avroData.get((byte[])pentahoData);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    protected Object getPrimitive(AvroInputField avroInputField, Object fieldValue, Schema s) throws KettleException {
        return this.m_avroToPdiConverter.converAvroToPdi(fieldValue, avroInputField, s);
    }

    protected Object getKettleValue(AvroInputField avroInputField, Object fieldValue) throws KettleException {
        switch (avroInputField.getTempValueMeta().getType()) {
            case 6: {
                return avroInputField.getTempValueMeta().getBigNumber(fieldValue);
            }
            case 8: {
                return avroInputField.getTempValueMeta().getBinary(fieldValue);
            }
            case 4: {
                return avroInputField.getTempValueMeta().getBoolean(fieldValue);
            }
            case 3: {
                if (avroInputField.getAvroType().getBaseType() == AvroSpec.DataType.INTEGER.getBaseType()) {
                    LocalDate localDate = LocalDate.ofEpochDay(0L).plusDays((Long)fieldValue);
                    return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                }
                if (avroInputField.getAvroType().getBaseType() == AvroSpec.DataType.STRING.getBaseType()) {
                    Object pentahoData = null;
                    String dateFormatStr = avroInputField.getStringFormat();
                    if (dateFormatStr == null || dateFormatStr.trim().length() == 0) {
                        dateFormatStr = ValueMetaBase.DEFAULT_DATE_FORMAT_MASK;
                    }
                    SimpleDateFormat datePattern = new SimpleDateFormat(dateFormatStr);
                    try {
                        return datePattern.parse(fieldValue.toString());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return avroInputField.getTempValueMeta().getDate(fieldValue);
            }
            case 9: {
                return new Timestamp((Long)fieldValue);
            }
            case 5: {
                return avroInputField.getTempValueMeta().getInteger(fieldValue);
            }
            case 1: {
                return avroInputField.getTempValueMeta().getNumber(fieldValue);
            }
            case 2: {
                return avroInputField.getTempValueMeta().getString(fieldValue);
            }
            case 10: {
                try {
                    return InetAddress.getByName(fieldValue.toString());
                }
                catch (UnknownHostException ex) {
                    return null;
                }
            }
        }
        return null;
    }

    protected static Schema checkUnion(Schema s) throws KettleException {
        boolean ok = false;
        List types = s.getTypes();
        Schema otherSchema = null;
        if (types.size() != 2) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnionError1", (String[])new String[0]));
        }
        for (Schema p : types) {
            if (p.getType() == Schema.Type.NULL) {
                ok = true;
                continue;
            }
            otherSchema = p;
        }
        if (!ok) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnionError2", (String[])new String[0]));
        }
        return otherSchema;
    }

    public static String cleansePath(String path) {
        String cleanKey;
        String key;
        int index = path.indexOf("${");
        int endIndex = 0;
        String tempStr = path;
        while (index >= 0 && (endIndex += tempStr.indexOf("}")) > 0 && endIndex > (index += 2) + 1 && endIndex + 1 < (path = path.replace(key = path.substring(index, endIndex), cleanKey = key.replace('.', '_'))).length()) {
            tempStr = path.substring(endIndex + 1, path.length());
            index = tempStr.indexOf("${");
            if (index <= 0) continue;
            index += endIndex;
        }
        return path;
    }

    public Object[][] avroObjectToKettle(Object[] incoming, VariableSpace space) throws KettleException {
        if (this.m_containerReader != null) {
            try {
                if (this.m_containerReader.hasNext()) {
                    if (this.m_topLevelRecord != null) {
                        this.m_topLevelRecord = (GenericData.Record)this.m_containerReader.next((Object)this.m_topLevelRecord);
                    } else if (this.m_topLevelArray != null) {
                        this.m_containerReader.next((Object)this.m_topLevelArray);
                    } else {
                        this.m_containerReader.next(this.m_topLevelMap);
                    }
                    return this.setKettleFields(incoming, space);
                }
                return null;
            }
            catch (IOException e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.ObjectReadError", (String[])new String[0]));
            }
        }
        try {
            if (this.m_decodingFromField) {
                Object fieldValue;
                if (incoming == null || incoming.length == 0) {
                    return null;
                }
                ValueMetaInterface fieldMeta = this.m_incomingRowMeta.getValueMeta(this.m_fieldToDecodeIndex);
                if (fieldMeta.isNull(incoming[this.m_fieldToDecodeIndex])) {
                    Object[][] result = new Object[][]{RowDataUtil.resizeArray((Object[])incoming, (int)this.m_outputRowMeta.size())};
                    return result;
                }
                if (this.m_schemaInField) {
                    ValueMetaInterface schemaMeta = this.m_incomingRowMeta.getValueMeta(this.m_schemaFieldIndex);
                    String schemaToUse = schemaMeta.getString(incoming[this.m_schemaFieldIndex]);
                    this.setSchemaToUse(schemaToUse, this.m_cacheSchemas, space);
                }
                if (this.m_jsonEncoded) {
                    try {
                        fieldValue = fieldMeta.getString(incoming[this.m_fieldToDecodeIndex]);
                        this.m_decoder = this.m_factory.jsonDecoder(this.m_schemaToUse, (String)fieldValue);
                    }
                    catch (IOException e) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.JsonDecoderError", (String[])new String[0]));
                    }
                } else {
                    fieldValue = fieldMeta.getBinary(incoming[this.m_fieldToDecodeIndex]);
                    this.m_decoder = this.m_factory.binaryDecoder(fieldValue, null);
                }
            }
            if (this.m_topLevelRecord != null) {
                this.m_topLevelRecord = (GenericData.Record)this.m_datumReader.read((Object)this.m_topLevelRecord, this.m_decoder);
            } else if (this.m_topLevelArray != null) {
                this.m_datumReader.read((Object)this.m_topLevelArray, this.m_decoder);
            } else {
                this.m_datumReader.read(this.m_topLevelMap, this.m_decoder);
            }
            return this.setKettleFields(incoming, space);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private Object[][] setKettleFields(Object[] outputRowData, VariableSpace space) throws KettleException {
        Object[][] result = null;
        if (this.m_expansionHandler != null) {
            this.m_expansionHandler.reset(space);
            result = this.m_schemaToUse.getType() == Schema.Type.RECORD || this.m_schemaToUse.getType() == Schema.Type.UNION ? this.m_expansionHandler.convertToKettleValues(this.m_topLevelRecord, this.m_topLevelRecord.getSchema(), this.m_defaultSchema, space, this.m_dontComplainAboutMissingFields) : (this.m_schemaToUse.getType() == Schema.Type.ARRAY ? this.m_expansionHandler.convertToKettleValues(this.m_topLevelArray, this.m_schemaToUse, this.m_defaultSchema, space, this.m_dontComplainAboutMissingFields) : this.m_expansionHandler.convertToKettleValues(this.m_topLevelMap, this.m_schemaToUse, this.m_defaultSchema, space, this.m_dontComplainAboutMissingFields));
        } else {
            result = new Object[1][];
        }
        outputRowData = outputRowData == null ? RowDataUtil.allocateRowData((int)this.m_outputRowMeta.size()) : RowDataUtil.createResizedCopy((Object[])outputRowData, (int)this.m_outputRowMeta.size());
        Object value = null;
        int incomingFieldsOffset = this.m_outputRowMeta.size() - this.m_normalFields.size();
        for (AvroInputField f : this.m_normalFields) {
            this.resetField(f, space);
            value = this.m_schemaToUse.getType() == Schema.Type.RECORD || this.m_schemaToUse.getType() == Schema.Type.UNION ? this.convertToKettleValue(f, this.m_topLevelRecord, this.m_topLevelRecord.getSchema(), this.m_defaultSchema, this.m_dontComplainAboutMissingFields) : (this.m_schemaToUse.getType() == Schema.Type.ARRAY ? this.convertToKettleValue(f, this.m_topLevelArray, this.m_schemaToUse, this.m_defaultSchema, this.m_dontComplainAboutMissingFields) : this.convertToKettleValue(f, this.m_topLevelMap, this.m_schemaToUse, this.m_defaultSchema, this.m_dontComplainAboutMissingFields));
            outputRowData[f.getOutputIndex() + incomingFieldsOffset] = value;
        }
        if (this.m_expansionHandler == null) {
            result[0] = outputRowData;
        } else if (this.m_normalFields.size() > 0 || this.m_newFieldOffset > 0) {
            for (int i = 0; i < result.length; ++i) {
                Object[] row = result[i];
                for (int j = 0; j < this.m_newFieldOffset; ++j) {
                    row[j] = outputRowData[j];
                }
                int rowIndex = 0;
                for (int x = 0; x < outputRowData.length; ++x) {
                    if (outputRowData[x] == null || rowIndex >= row.length) continue;
                    row[rowIndex++] = outputRowData[x];
                }
            }
        }
        return result;
    }

    public void close() throws IOException {
        if (this.m_containerReader != null) {
            this.m_containerReader.close();
        }
        if (this.m_inStream != null) {
            this.m_inStream.close();
        }
    }

    protected void setSchemaToUse(String schemaKey, boolean useCache, VariableSpace space) throws KettleException {
        if (Const.isEmpty((String)schemaKey)) {
            if (this.m_defaultDatumReader == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.IncommingSchemaIsMissingAndNoDefault", (String[])new String[0]));
            }
            if (this.m_log.isDetailed()) {
                this.m_log.logDetailed(BaseMessages.getString(PKG, (String)"AvroInput.Message.IncommingSchemaIsMissing", (String[])new String[0]));
            }
            this.m_datumReader = this.m_defaultDatumReader;
            this.m_schemaToUse = this.m_datumReader.getSchema();
            this.setTopLevelStructure(this.m_defaultTopLevelObject);
            return;
        }
        schemaKey = schemaKey.trim();
        schemaKey = space.environmentSubstitute(schemaKey);
        Object[] cached = null;
        if (useCache) {
            cached = this.m_schemaCache.get(schemaKey);
            if (this.m_log.isDetailed() && cached != null) {
                this.m_log.logDetailed(BaseMessages.getString(PKG, (String)"AvroInput.Message.UsingCachedSchema", (String[])new String[]{schemaKey}));
            }
        }
        if (!useCache || cached == null) {
            Schema toUse = null;
            if (this.m_schemaFieldIsPath) {
                if (this.m_log.isDetailed()) {
                    this.m_log.logDetailed(BaseMessages.getString(PKG, (String)"AvroInput.Message.LoadingSchema", (String[])new String[]{schemaKey}));
                }
                try {
                    toUse = AvroNestedReader.loadSchema(schemaKey);
                }
                catch (KettleException ex) {
                    if (this.m_defaultDatumReader != null) {
                        if (this.m_log.isBasic()) {
                            this.m_log.logBasic(BaseMessages.getString(PKG, (String)"AvroInput.Message.FailedToLoadSchmeaUsingDefault", (String[])new String[]{schemaKey}));
                        }
                        this.m_datumReader = this.m_defaultDatumReader;
                        this.m_schemaToUse = this.m_datumReader.getSchema();
                        this.setTopLevelStructure(this.m_defaultTopLevelObject);
                        return;
                    }
                    throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.CantLoadIncommingSchemaAndNoDefault", (String[])new String[]{schemaKey}));
                }
            } else {
                if (this.m_log.isDetailed()) {
                    this.m_log.logDetailed(BaseMessages.getString(PKG, (String)"AvroInput.Message.ParsingSchema", (String[])new String[]{schemaKey}));
                }
                Schema.Parser p = new Schema.Parser();
                toUse = p.parse(schemaKey);
            }
            this.m_schemaToUse = toUse;
            this.m_datumReader = new GenericDatumReader(toUse);
            this.initTopLevelStructure(toUse, false);
            if (useCache) {
                Object[] schemaInfo = new Object[2];
                schemaInfo[0] = this.m_datumReader;
                Object object = this.m_topLevelArray != null ? this.m_topLevelArray : (schemaInfo[1] = this.m_topLevelRecord != null ? this.m_topLevelRecord : this.m_topLevelMap);
                if (this.m_log.isDetailed()) {
                    this.m_log.logDetailed(BaseMessages.getString(PKG, (String)"AvroInput.Message.StoringSchemaInCache", (String[])new String[0]));
                }
                this.m_schemaCache.put(schemaKey, schemaInfo);
            }
        } else if (useCache) {
            this.m_datumReader = (GenericDatumReader)cached[0];
            this.m_schemaToUse = this.m_datumReader.getSchema();
            this.setTopLevelStructure(cached[1]);
        }
    }

    protected void setTopLevelStructure(Object topLevel) {
        if (topLevel instanceof GenericData.Record) {
            this.m_topLevelRecord = (GenericData.Record)topLevel;
            this.m_topLevelArray = null;
            this.m_topLevelMap = null;
        } else if (topLevel instanceof GenericData.Array) {
            this.m_topLevelArray = (GenericData.Array)topLevel;
            this.m_topLevelRecord = null;
            this.m_topLevelMap = null;
        } else {
            this.m_topLevelMap = (HashMap)topLevel;
            this.m_topLevelRecord = null;
            this.m_topLevelArray = null;
        }
    }

    protected static Schema loadSchema(String schemaFile) throws KettleException {
        Schema s = null;
        Schema.Parser p = new Schema.Parser();
        FileObject fileO = KettleVFS.getFileObject((String)schemaFile);
        try {
            InputStream in = KettleVFS.getInputStream((FileObject)fileO);
            s = p.parse(in);
            in.close();
        }
        catch (FileSystemException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.SchemaError", (String[])new String[0]), (Throwable)e);
        }
        catch (IOException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.SchemaError", (String[])new String[0]), (Throwable)e);
        }
        return s;
    }

    protected static Schema loadSchemaFromContainer(String containerFilename) throws KettleException {
        Schema s = null;
        FileObject fileO = KettleVFS.getFileObject((String)containerFilename);
        InputStream in = null;
        try {
            in = KettleVFS.getInputStream((FileObject)fileO);
            GenericDatumReader dr = new GenericDatumReader();
            DataFileStream reader = new DataFileStream(in, (DatumReader)dr);
            s = reader.getSchema();
            reader.close();
        }
        catch (FileSystemException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInputDialog.Error.KettleFileException", (String[])new String[0]), (Throwable)e);
        }
        catch (IOException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInputDialog.Error.KettleFileException", (String[])new String[0]), (Throwable)e);
        }
        return s;
    }

    public class AvroArrayExpansion {
        public String m_expansionPath;
        protected List<AvroInputField> m_subFields;
        private List<String> m_pathParts;
        private List<String> m_tempParts;
        protected RowMetaInterface m_outputRowMeta;

        public AvroArrayExpansion(List<AvroInputField> subFields) {
            this.m_subFields = subFields;
        }

        public void init() throws KettleException {
            if (Const.isEmpty((String)this.m_expansionPath)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.NoPathSet", (String[])new String[0]));
            }
            if (this.m_pathParts != null) {
                return;
            }
            String expansionPath = AvroNestedReader.cleansePath(this.m_expansionPath);
            String[] temp = expansionPath.split("\\.");
            this.m_pathParts = new ArrayList<String>();
            for (String part : temp) {
                this.m_pathParts.add(part);
            }
            if (this.m_pathParts.get(0).equals("$")) {
                this.m_pathParts.remove(0);
            } else if (this.m_pathParts.get(0).startsWith("$[")) {
                String r = this.m_pathParts.get(0).substring(1, this.m_pathParts.get(0).length());
                this.m_pathParts.set(0, r);
            }
            this.m_tempParts = new ArrayList<String>();
            if (this.m_subFields != null) {
                for (AvroInputField f : this.m_subFields) {
                    int outputIndex = this.m_outputRowMeta.indexOfValue(f.getPentahoFieldName());
                    AvroNestedReader.this.fieldInit(f, outputIndex);
                }
            }
        }

        public void reset(VariableSpace space) {
            this.m_tempParts.clear();
            for (String part : this.m_pathParts) {
                if (space == null) {
                    this.m_tempParts.add(part);
                    continue;
                }
                this.m_tempParts.add(space.environmentSubstitute(part));
            }
            for (AvroInputField f : this.m_subFields) {
                AvroNestedReader.this.resetField(f, space);
            }
        }

        public Object[][] convertToKettleValues(Map<Utf8, Object> map, Schema s, Schema defaultSchema, VariableSpace space, boolean ignoreMissing) throws KettleException {
            if (map == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathMap", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) != '[') {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathMap2", (String[])new String[]{part}));
            }
            String key = part.substring(1, part.indexOf(93));
            if (part.indexOf(93) < part.length() - 1) {
                part = part.substring(part.indexOf(93) + 1, part.length());
                this.m_tempParts.add(0, part);
            }
            if (key.equals("*")) {
                Schema valueType = s.getValueType();
                Object[][] result = new Object[map.keySet().size()][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                int i = 0;
                for (Utf8 mk : map.keySet()) {
                    Object value = map.get(mk);
                    for (int j = 0; j < this.m_subFields.size(); ++j) {
                        AvroInputField sf = this.m_subFields.get(j);
                        AvroNestedReader.this.resetField(sf, space);
                        result[i][sf.getOutputIndex()] = valueType.getType() == Schema.Type.RECORD ? AvroNestedReader.this.convertToKettleValue(sf, (GenericData.Record)value, valueType, defaultSchema, ignoreMissing) : (valueType.getType() == Schema.Type.ARRAY ? AvroNestedReader.this.convertToKettleValue(sf, (GenericData.Array)value, valueType, defaultSchema, ignoreMissing) : (valueType.getType() == Schema.Type.MAP ? AvroNestedReader.this.convertToKettleValue(sf, (Map)value, valueType, defaultSchema, ignoreMissing) : AvroNestedReader.this.getPrimitive(sf, value, valueType)));
                    }
                    ++i;
                }
                return result;
            }
            Object value = map.get(new Utf8(key));
            if (value == null) {
                Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                for (int i = 0; i < this.m_subFields.size(); ++i) {
                    AvroInputField sf = this.m_subFields.get(i);
                    result[0][sf.getOutputIndex()] = null;
                }
                return result;
            }
            Schema valueType = s.getValueType();
            if (valueType.getType() == Schema.Type.UNION) {
                if (value instanceof GenericContainer) {
                    valueType = ((GenericContainer)value).getSchema();
                } else if (value instanceof Map) {
                    Schema mapSchema = null;
                    for (Schema ts : valueType.getTypes()) {
                        if (ts.getType() != Schema.Type.MAP) continue;
                        mapSchema = ts;
                        break;
                    }
                    if (mapSchema == null) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                    }
                    valueType = mapSchema;
                } else {
                    if (!ignoreMissing) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.EncounteredAPrimitivePriorToMapExpansion", (String[])new String[0]));
                    }
                    Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                    return result;
                }
            }
            if (valueType.getType() == Schema.Type.RECORD) {
                return this.convertToKettleValues((GenericData.Record)value, valueType, defaultSchema, space, ignoreMissing);
            }
            if (valueType.getType() == Schema.Type.ARRAY) {
                return this.convertToKettleValues((GenericData.Array)value, valueType, defaultSchema, space, ignoreMissing);
            }
            if (valueType.getType() == Schema.Type.MAP) {
                return this.convertToKettleValues((Map)value, valueType, defaultSchema, space, ignoreMissing);
            }
            if (!ignoreMissing) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnexpectedMapValueTypeAtNonExpansionPoint", (String[])new String[0]));
            }
            Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
            return result;
        }

        public Object[][] convertToKettleValues(GenericData.Array array, Schema s, Schema defaultSchema, VariableSpace space, boolean ignoreMissing) throws KettleException {
            if (array == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathArray", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) != '[') {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathArray2", (String[])new String[]{part}));
            }
            String index = part.substring(1, part.indexOf(93));
            if (part.indexOf(93) < part.length() - 1) {
                part = part.substring(part.indexOf(93) + 1, part.length());
                this.m_tempParts.add(0, part);
            }
            if (index.equals("*")) {
                Schema elementType = s.getElementType();
                Object[][] result = new Object[array.size()][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                for (int i = 0; i < array.size(); ++i) {
                    Object value = array.get(i);
                    for (int j = 0; j < this.m_subFields.size(); ++j) {
                        AvroInputField sf = this.m_subFields.get(j);
                        AvroNestedReader.this.resetField(sf, space);
                        result[i][sf.getOutputIndex()] = elementType.getType() == Schema.Type.RECORD ? AvroNestedReader.this.convertToKettleValue(sf, (GenericData.Record)value, elementType, defaultSchema, ignoreMissing) : (elementType.getType() == Schema.Type.ARRAY ? AvroNestedReader.this.convertToKettleValue(sf, (GenericData.Array)value, elementType, defaultSchema, ignoreMissing) : (elementType.getType() == Schema.Type.MAP ? AvroNestedReader.this.convertToKettleValue(sf, (Map)value, elementType, defaultSchema, ignoreMissing) : AvroNestedReader.this.getPrimitive(sf, value, elementType)));
                    }
                }
                return result;
            }
            int arrayI = 0;
            try {
                arrayI = Integer.parseInt(index.trim());
            }
            catch (NumberFormatException e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToParseArrayIndex", (String[])new String[]{index}));
            }
            if (arrayI >= array.size() || arrayI < 0) {
                Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                for (int i = 0; i < this.m_subFields.size(); ++i) {
                    AvroInputField sf = this.m_subFields.get(i);
                    result[0][sf.getOutputIndex()] = null;
                }
                return result;
            }
            Object value = array.get(arrayI);
            Schema elementType = s.getElementType();
            if (elementType.getType() == Schema.Type.UNION) {
                if (value instanceof GenericContainer) {
                    elementType = ((GenericContainer)value).getSchema();
                } else if (value instanceof Map) {
                    Schema mapSchema = null;
                    for (Schema ts : elementType.getTypes()) {
                        if (ts.getType() != Schema.Type.MAP) continue;
                        mapSchema = ts;
                        break;
                    }
                    if (mapSchema == null) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                    }
                    elementType = mapSchema;
                } else {
                    if (!ignoreMissing) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.EncounteredAPrimitivePriorToMapExpansion", (String[])new String[0]));
                    }
                    Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                    return result;
                }
            }
            if (elementType.getType() == Schema.Type.RECORD) {
                return this.convertToKettleValues((GenericData.Record)value, elementType, defaultSchema, space, ignoreMissing);
            }
            if (elementType.getType() == Schema.Type.ARRAY) {
                return this.convertToKettleValues((GenericData.Array)value, elementType, defaultSchema, space, ignoreMissing);
            }
            if (elementType.getType() == Schema.Type.MAP) {
                return this.convertToKettleValues((Map)value, elementType, defaultSchema, space, ignoreMissing);
            }
            if (!ignoreMissing) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnexpectedArrayElementTypeAtNonExpansionPoint", (String[])new String[0]));
            }
            Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
            return result;
        }

        public Object[][] convertToKettleValues(GenericData.Record record, Schema s, Schema defaultSchema, VariableSpace space, boolean ignoreMissing) throws KettleException {
            Schema.Field fieldS;
            if (record == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathRecord", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) == '[') {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.InvalidPath", (String[])new String[0]) + this.m_tempParts);
            }
            if (part.indexOf(91) > 0) {
                String arrayPart = part.substring(part.indexOf(91));
                part = part.substring(0, part.indexOf(91));
                this.m_tempParts.add(0, arrayPart);
            }
            if ((fieldS = s.getField(part)) == null && !ignoreMissing) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.NonExistentField", (String[])new String[]{part}));
            }
            Object field = record.get(part);
            if (field == null) {
                Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                return result;
            }
            Schema.Type fieldT = fieldS.schema().getType();
            Schema fieldSchema = fieldS.schema();
            if (fieldT == Schema.Type.UNION) {
                if (field instanceof GenericContainer) {
                    fieldSchema = ((GenericContainer)field).getSchema();
                    fieldT = fieldSchema.getType();
                } else if (field instanceof Map) {
                    Schema mapSchema = null;
                    for (Schema ts : fieldSchema.getTypes()) {
                        if (ts.getType() != Schema.Type.MAP) continue;
                        mapSchema = ts;
                        break;
                    }
                    if (mapSchema == null) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                    }
                    fieldSchema = mapSchema;
                    fieldT = Schema.Type.MAP;
                } else {
                    if (!ignoreMissing) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.EncounteredAPrimitivePriorToMapExpansion", (String[])new String[0]));
                    }
                    Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                    return result;
                }
            }
            if (fieldT == Schema.Type.RECORD) {
                return this.convertToKettleValues((GenericData.Record)field, fieldSchema, defaultSchema, space, ignoreMissing);
            }
            if (fieldT == Schema.Type.ARRAY) {
                return this.convertToKettleValues((GenericData.Array)field, fieldSchema, defaultSchema, space, ignoreMissing);
            }
            if (fieldT == Schema.Type.MAP) {
                return this.convertToKettleValues((Map)field, fieldSchema, defaultSchema, space, ignoreMissing);
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnexpectedRecordFieldTypeAtNonExpansionPoint", (String[])new String[0]));
        }
    }
}

