/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet.delegate.apache;

import java.io.IOException;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.hadoop.ParquetRecordWriter;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.hadoop.shim.api.format.IPentahoOutputFormat;

public class PentahoParquetRecordWriter
implements IPentahoOutputFormat.IPentahoRecordWriter {
    private final ParquetRecordWriter<RowMetaAndData> nativeParquetRecordWriter;
    private final TaskAttemptContext taskAttemptContext;

    public PentahoParquetRecordWriter(ParquetRecordWriter<RowMetaAndData> recordWriter, TaskAttemptContext taskAttemptContext) {
        this.nativeParquetRecordWriter = recordWriter;
        this.taskAttemptContext = taskAttemptContext;
    }

    public void write(RowMetaAndData row) {
        try {
            this.nativeParquetRecordWriter.write(null, (Object)row);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("some exception while writing ", e);
        }
        catch (InterruptedException e) {
            throw new IllegalArgumentException("interrupted exception writing parquet ", e);
        }
    }

    public void close() throws IOException {
        try {
            this.nativeParquetRecordWriter.close(this.taskAttemptContext);
        }
        catch (InterruptedException e) {
            throw new IllegalArgumentException("interrupted exception writing parquet ", e);
        }
    }
}

