/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.endpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.api.providers.FromTo;
import org.pentaho.di.plugins.fileopensave.api.providers.Tree;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileException;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileNotFoundException;
import org.pentaho.di.plugins.fileopensave.controllers.FileController;
import org.pentaho.di.plugins.fileopensave.controllers.RepositoryBrowserController;

public class FileBrowserEndpoint {
    private final RepositoryBrowserController repositoryBrowserController;
    private final FileController fileController;

    public FileBrowserEndpoint(RepositoryBrowserController repositoryBrowserController, FileController fileController) {
        this.repositoryBrowserController = repositoryBrowserController;
        this.fileController = fileController;
    }

    @GET
    @Path(value="/loadDirectoryTree{filter : (/filter)?}")
    @Produces(value={"application/json"})
    public Response loadDirectoryTree(@PathParam(value="filter") String filter, @QueryParam(value="connectionTypes") String connectionTypes) {
        ArrayList<String> connectionTypeList = new ArrayList<String>();
        if (connectionTypes != null) {
            Collections.addAll(connectionTypeList, connectionTypes.split(","));
        }
        List<Tree> trees = this.fileController.load(filter, connectionTypeList);
        return Response.ok(trees).build();
    }

    @POST
    @Path(value="/getFiles")
    @Produces(value={"application/json"})
    public Response getFiles(@QueryParam(value="filters") String filters, @QueryParam(value="useCache") Boolean useCache, File file) {
        if (!(useCache = Boolean.valueOf(useCache != null ? useCache : true)).booleanValue()) {
            this.fileController.clearCache(file);
        }
        try {
            return Response.ok(this.fileController.getFiles(file, filters, useCache)).build();
        }
        catch (FileException e) {
            if (e instanceof FileNotFoundException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
    }

    @POST
    @Path(value="/getFile")
    @Produces(value={"application/json"})
    public Response getFile(File file) {
        File result = this.fileController.getFile(file);
        if (result == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/delete")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteFiles(List<File> files) {
        return Response.ok((Object)this.fileController.delete(files)).build();
    }

    @PUT
    @Path(value="/add")
    @Produces(value={"application/json"})
    public Response addFolder(File folder) {
        return Response.ok((Object)this.fileController.add(folder)).build();
    }

    @POST
    @Path(value="/move")
    @Produces(value={"application/json"})
    public Response move(@QueryParam(value="overwrite") Boolean overwrite, @QueryParam(value="path") String path, FromTo fromTo) {
        overwrite = overwrite != null ? overwrite : false;
        return Response.ok((Object)this.fileController.moveFile(fromTo.getFrom(), fromTo.getTo(), path, overwrite)).build();
    }

    @POST
    @Path(value="/rename")
    @Produces(value={"application/json"})
    public Response rename(@QueryParam(value="overwrite") Boolean overwrite, @QueryParam(value="newPath") String newPath, File file) {
        overwrite = overwrite != null ? overwrite : false;
        return Response.ok((Object)this.fileController.rename(file, newPath, overwrite)).build();
    }

    @POST
    @Path(value="/copy")
    @Produces(value={"application/json"})
    public Response copy(@QueryParam(value="overwrite") Boolean overwrite, @QueryParam(value="path") String path, FromTo fromTo) {
        overwrite = overwrite != null ? overwrite : false;
        return Response.ok((Object)this.fileController.copyFile(fromTo.getFrom(), fromTo.getTo(), path, overwrite)).build();
    }

    @POST
    @Path(value="/fileExists")
    @Produces(value={"application/json"})
    public Response fileExists(@QueryParam(value="newPath") String newPath, File destDir) {
        return Response.ok((Object)this.fileController.fileExists(destDir, newPath)).build();
    }

    @POST
    @Path(value="/getNewName")
    @Produces(value={"application/json"})
    public Response getNewName(@QueryParam(value="newPath") String newPath, File destDir) {
        return Response.ok((Object)this.fileController.getNewName(destDir, newPath)).build();
    }

    @POST
    @Path(value="/clearCache")
    @Produces(value={"application/json"})
    public Response clearCache(File file) {
        return Response.ok((Object)this.fileController.clearCache(file)).build();
    }

    @GET
    @Path(value="/getActiveFileName")
    public Response getActiveFileName() {
        String name = this.repositoryBrowserController.getActiveFileName();
        return Response.ok(Collections.singletonMap("fileName", name)).build();
    }

    @GET
    @Path(value="/loadRecent/{repo}/{id}")
    public Response loadRecent(@PathParam(value="repo") String repo, @PathParam(value="id") String id) {
        if (this.repositoryBrowserController.openRecentFile(repo, id)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/saveFile/{path}/{name}/{fileName}/{override}")
    public Response saveFile(@PathParam(value="path") String path, @PathParam(value="name") String name, @PathParam(value="fileName") String fileName, @PathParam(value="override") String override) {
        boolean overwrite;
        boolean bl = overwrite = override != null && override.toLowerCase().equals("true");
        if (this.repositoryBrowserController.saveFile(path, name, fileName, overwrite)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/saveFile/{path}/{name}/{override}")
    public Response saveFile(@PathParam(value="path") String path, @PathParam(value="name") String name, @PathParam(value="override") String override) {
        boolean overwrite;
        boolean bl = overwrite = override != null && override.toLowerCase().equals("true");
        if (this.repositoryBrowserController.saveFile(path, name, "", overwrite)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/checkForSecurityOrDupeIssues/{path}/{name}/{fileName}/{override}")
    public Response checkForSecurityOrDupeIssues(@PathParam(value="path") String path, @PathParam(value="name") String name, @PathParam(value="fileName") String fileName, @PathParam(value="override") String override) {
        boolean overwrite;
        boolean bl = overwrite = override != null && override.toLowerCase().equals("true");
        if (this.repositoryBrowserController.checkForSecurityOrDupeIssues(path, name, fileName, overwrite)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/checkForSecurityOrDupeIssues/{path}/{name}/{override}")
    public Response checkForSecurityOrDupeIssues(@PathParam(value="path") String path, @PathParam(value="name") String name, @PathParam(value="override") String override) {
        boolean overwrite;
        boolean bl = overwrite = override != null && override.toLowerCase().equals("true");
        if (this.repositoryBrowserController.checkForSecurityOrDupeIssues(path, name, "", overwrite)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/search/{path}/{filter}")
    @Produces(value={"application/json"})
    public Response search(@PathParam(value="path") String path, @PathParam(value="filter") String filter) {
        return Response.ok(this.repositoryBrowserController.search(path, filter)).build();
    }

    @GET
    @Path(value="/updateRecentFiles/{oldPath}/{newPath}")
    @Produces(value={"application/json"})
    public Response updateRecentFiles(@PathParam(value="oldPath") String oldPath, @PathParam(value="newPath") String newPath) {
        return Response.ok((Object)this.repositoryBrowserController.updateRecentFiles(oldPath, newPath)).build();
    }

    @GET
    @Path(value="/recentSearches")
    @Produces(value={"application/json"})
    public Response recentSearches() {
        return Response.ok((Object)this.repositoryBrowserController.getRecentSearches()).build();
    }

    @GET
    @Path(value="/storeRecentSearch/{recentSearch}")
    @Produces(value={"application/json"})
    public Response storeRecentSearch(@PathParam(value="recentSearch") String recentSearch) {
        return Response.ok((Object)this.repositoryBrowserController.storeRecentSearch(recentSearch)).build();
    }

    @GET
    @Path(value="/currentRepo")
    @Produces(value={"application/json"})
    public Response getCurrentRepo() {
        return Response.ok((Object)this.repositoryBrowserController.getCurrentRepo()).build();
    }
}

