/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.recents.model;

import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseEntity;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.providers.recents.model.RecentUtils;

public class RecentFile
extends BaseEntity
implements File {
    private static final String TRANSFORMATION = "transformation";
    private static final String JOB = "job";
    private String type;
    private String repository;
    private String username;

    public String getProvider() {
        return "recents";
    }

    public static RecentFile create(LastUsedFile lastUsedFile) {
        RecentFile recentFile = new RecentFile();
        recentFile.setType(lastUsedFile.isTransformation() ? TRANSFORMATION : JOB);
        recentFile.setDate(lastUsedFile.getLastOpened());
        recentFile.setRoot("Recents");
        RecentUtils.setPaths(lastUsedFile, recentFile);
        return recentFile;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

