/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.getfields.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.ui.core.dialog.ThinDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.ServerPortRegistry;

public class GetFieldsDialog
extends ThinDialog {
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private static final int OPTIONS = 68720;
    private static final String OSGI_SERVICE_PORT = "OSGI_SERVICE_PORT";
    private static final String THIN_CLIENT_HOST = "THIN_CLIENT_HOST";
    private static final String THIN_CLIENT_PORT = "THIN_CLIENT_PORT";
    private static final String LOCALHOST = "127.0.0.1";
    private List<String> paths = new ArrayList<String>();
    private String title = "";
    private String file;
    private String type = "";

    public GetFieldsDialog(Shell shell, int width, int height, String file, List<String> paths) {
        super(shell, width, height);
        this.file = file;
        this.paths = paths;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public void open() {
        StringBuilder clientPath = new StringBuilder();
        clientPath.append(GetFieldsDialog.getClientPath());
        clientPath.append("#?path=");
        clientPath.append(this.file);
        clientPath.append("&type=");
        clientPath.append(this.type);
        if (this.paths.size() > 0) {
            clientPath.append("&paths=");
            clientPath.append(String.join((CharSequence)",", this.paths));
        }
        this.createDialog(this.title, GetFieldsDialog.getRepoURL(clientPath.toString()), 68720, LOGO);
        this.dialog.setMinimumSize(470, 580);
        new BrowserFunction(this.browser, "close"){

            public Object function(Object[] arguments) {
                GetFieldsDialog.this.paths = new ArrayList();
                GetFieldsDialog.this.browser.dispose();
                GetFieldsDialog.this.dialog.close();
                GetFieldsDialog.this.dialog.dispose();
                return true;
            }
        };
        new BrowserFunction(this.browser, "ok"){

            public Object function(Object[] arguments) {
                GetFieldsDialog.this.paths = new ArrayList();
                for (Object path : (Object[])arguments[0]) {
                    GetFieldsDialog.this.paths.add((String)path);
                }
                GetFieldsDialog.this.browser.dispose();
                GetFieldsDialog.this.dialog.close();
                GetFieldsDialog.this.dialog.dispose();
                return true;
            }
        };
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private static String getClientPath() {
        Properties properties = new Properties();
        try (InputStream inputStream = GetFieldsDialog.class.getClassLoader().getResourceAsStream("project.properties");){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties.getProperty("CLIENT_PATH");
    }

    private static String getRepoURL(String path) {
        Integer port;
        String host;
        try {
            host = GetFieldsDialog.getKettleProperty(THIN_CLIENT_HOST);
            port = Integer.valueOf(GetFieldsDialog.getKettleProperty(THIN_CLIENT_PORT));
        }
        catch (Exception e) {
            host = LOCALHOST;
            port = GetFieldsDialog.getOsgiServicePort();
        }
        return "http://" + host + ":" + port + path;
    }

    private static String getKettleProperty(String propertyName) throws KettleException {
        return System.getProperty(propertyName);
    }

    private static Integer getOsgiServicePort() {
        ServerPort osgiServicePort = ServerPortRegistry.getPort((String)OSGI_SERVICE_PORT);
        if (osgiServicePort != null) {
            return osgiServicePort.getAssignedPort();
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

